<?php
/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS ######################
define('THIS_SCRIPT', 'downloads');
define('CVS_REVISION', '$RCSfile: vbdownloads.php,v $ - $Revision: $WCREV$ $');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('dbtech_downloads', 'cphome', 'logging', 'threadmanage', 'banning', 'cpuser', 'cpoption', 'cppermission');

// get special data templates from the datastore
$specialtemplates = array('dbtech_downloads_categories');

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

// ############################# LOG ACTION ##############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (!empty($_POST['do']))
{
	// $_POST requests take priority
	$action = $_POST['do'];
}
else if (!empty($_GET['do']))
{
	// We had a GET request instead
	$action = $_GET['do'];
}
else
{
	// No request
	$action = 'home';
}

require_once(DIR . '/dbtech/downloads/core/class_download.php');

$dbtech_class = 'Downloads';

if (file_exists(DIR . '/dbtech/downloads_pro/core/class_downloads_pro.php')) {
    require_once(DIR . '/dbtech/downloads_pro/core/class_downloads_pro.php');
    
    $dbtech_class = 'Downloads_Pro';
}

if (file_exists(DIR . '/dbtech/downloads/actions/admin/' . $action . '.php'))
{
	if (file_exists(DIR . '/dbtech/downloads_pro/actions/admin/' . $action . '.php'))
	{
		// Include the selected file
		include_once(DIR . '/dbtech/downloads_pro/actions/admin/' . $action . '.php');	
	}
	else
	{
		// Include the selected file
		include_once(DIR . '/dbtech/downloads/actions/admin/' . $action . '.php');	
	}
}
else
{
	// Throw error from invalid action
	print_cp_message($vbphrase['dbtech_downloads_invalid_action']);
}

?>